## Cisco Secure Network Analytics Overview

- Employs a **behavior-based system** to analyze network telemetry and uncover cyber attacks and insider threats.
- Moves beyond signature-based monitoring for a **holistic view of network activity**.
- Uses **network behavioral analysis** to identify irregularities and suspicious patterns.

---

## Visibility and Data Analysis

### Full Network Visibility

- Provides **comprehensive visibility** into your entire network, crucial for effective defense.
- Ensures that **every IP-connected endpoint** (including IoT, medical, industrial, wired, and wireless devices) is visible.

### Telemetry and Intelligence

- **Transforms telemetry data** from network devices (routers, switches, firewalls, etc.) into actionable intelligence.
- Aggregates and organizes data in both **standard database and graphical formats** for in-depth analysis.

### Types of Flow Data

- Supports flow data produced by **NetFlow, JFlow, sFlow, and IP Flow Information Export (IPFIX)**.
- Captures information about **all IP conversations**, including TCP, UDP, multicast, and broadcast for both IPv4 and IPv6.

---

## Deployment Architecture

### Solution Form Factors

- Available as an **on-premises solution** (physical or virtual).

### Core Components

- **Cisco Secure Network Analytics Manager**
- **Cisco Secure Network Analytics Flow Collector**
- **Cisco Secure Network Analytics Flow Rate License**

### Optional Components

- **Cisco Secure Network Analytics Flow Sensor**
    - Generates NetFlow data for devices that cannot produce it natively.
    - Installed on a mirroring port or network tap.
    - Converts raw data into NetFlow format and sends it to the Flow Collector.
    - Adds **application-layer visibility** and additional security context.

---

## Network Intelligence and Response

### Host Groups

- Administratively defined **logical groupings of hosts**.
- Enhance analysis and results as more host groups are utilized.

### Statistical Baselines and Anomaly Detection

- Provides **statistical baselines** for network segmentation and business analysis.
- Classifiers use multiple statistics to find **anomalous behavior** (not all anomalies are threats).
- Includes **built-in policies** for known and anomalous behavior.
- Supports **custom security events** for tailored detection.

---

## Threat Response and Integrations

### Automated Threat Response

- **Automates detection and response** to security threats.
- Provides actionable **threat intelligence** for security teams.

### Integrations for Enhanced Intelligence

- **Cisco Talos (Threat Intelligence License)**: Delivers up-to-date threat intelligence.
- **Cisco Global Threat Alerts (formerly Cognitive Intelligence)**: Adds capabilities for web-based threats, including **Encrypted Traffic Analytics (ETA)**.
    - Detects suspicious web traffic and responds to ongoing attacks.
- **Cisco ISE Integration (via pxGrid)**: Enables **rapid threat containment** within the network.

---

### Notes

- Anomalies detected may result from system issues or policy deviations, not just threats.
- Host group configuration is key for maximizing solution effectiveness.